<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Stream extends Model 
{

    protected $table = 'stream';
    public $timestamps = true;
    protected $fillable = array('node_id', 'name');

    public function node()
    {
        return $this->belongsTo('Node');
    }

    public function streamScheduledItems()
    {
        return $this->hasMany('StreamScheduledItem');
    }

    public function contentUpdates()
    {
        return $this->hasMany('ContentUpdate');
    }

}